// Procedure Loader Hide
#pragma hide = 1
#pragma rtGlobals=3
#pragma rtFunctionErrors=1
#pragma IgorVersion=9
#pragma TextEncoding="UTF-8"

// Math Panel for SpXZeigR
// author: jjw

#pragma ModuleName=SpXZgRMath

StrConstant k_SpXZgRMathPanel = "SpXZgRMathPanel"
Constant k_spxzgrmpwidth=410
Constant k_spxzgrmpheight=190

// @brief strucure for math panel
Structure SpXZgR_MathStruct
	string srcGraphName
	string srcGraphTitle
	string TraceList
	int32 method
	string src
	string ref
	double sf
	double ex
	double offset
	int32 zatc
	double patc
	int32 sabs
	int32 apnts
EndStructure

// @brief initialize the math structure
Function init_SpXZgRMathStruct(STRUCT SpXZgR_MathStruct &math)

	string fWin, theList, theTrace
	fWin = StringFromList(0,WinList("!SpXZgRMathGraph",";","WIN:1"))
	math.srcGraphName = fWin
	GetWindow $fWin, wtitle
	math.srcGraphTitle = s_value
	theList = TraceNameList(fWin,";",1+4)
	math.TraceList = theList
	theTrace = StringFromList(1,theList)
	wave wS = TraceNameToWaveRef(fWin,theTrace)
	math.src = theTrace
	theTrace = StringFromList(0,theList)
	wave wR = TraceNameToWaveRef(fWin,theTrace)
	math.ref = theTrace

	math.method = 1
	math.sf = 1
	math.ex = 0
	math.offset = 0
	math.zatc = 0
	math.patc = 0
	math.sabs = 0
	math.apnts = 3
	
	return 0
end

// @brief get values for strucure for math panel
Static Function fill_SpXZgRMathStruct(STRUCT SpXZgR_MathStruct &math)

	ControlInfo/W=$k_SpXZgRMathPanel srcGraphName
	math.srcGraphName = s_value
	math.TraceList = TraceNameList(s_value,";",1+4)
	GetWindow $s_value wtitle
	math.srcGraphtitle = s_value
	ControlInfo/W=$k_SpXZgRMathPanel pSpectrum
	math.src = s_value
	ControlInfo/W=$k_SpXZgRMathPanel pReference
	math.ref = s_value
	ControlInfo/W=$k_SpXZgRMathPanel method
	math.method = v_value
	ControlInfo/W=$k_SpXZgRMathPanel scalefactor
	math.sf = v_value
	ControlInfo/W=$k_SpXZgRMathPanel exponent
	math.ex = v_value
	ControlInfo/W=$k_SpXZgRMathPanel offset
	math.offset = v_value
	ControlInfo/W=$k_SpXZgRMathPanel checkzero
	math.zatc = v_value
	if (v_value == 1)
		math.patc = pcsr(A,"SpXZgRMathGraph")
	endif
	ControlInfo/W=$k_SpXZgRMathPanel checkabs
	math.sabs = v_value
	ControlInfo/W=$k_SpXZgRMathPanel autopnts
	math.apnts = v_value
	
	return 0
end

// @brief trace name list
// @input wbase=1 includes zero in list
Static Function/S f_TraceList([variable wbase])

	string rstr, fWin
	fWin = StringFromList(0,WinList("!SpXZgRMathGraph",";","WIN:1"))
	rstr = TraceNameList(fWin,";",1+4)
	if (!ParamIsDefault(wbase))
		rstr = "zero;" + rstr
	endif
	return rstr
end

// @brief start the math operations
Function start_SpXZgRMath()

	if (invalid_SpXZgRMath())
		return -1
	endif
	show_SpXZgRMathGraph(0)
	attach_SpXZgRMathPanel()
	reset_SpXZgRMathPanel(0)
	show_SpXZgRMathGraph(1)
	return 0
end

// @brief report whether math operation can be done
// @return 0 - no error, -1 - error
Static Function invalid_SpXZgRMath()

	string fWin = WinName(0,1,1)
	string tList = TraceNameList(fWin,";",1)
	variable ic, ntraces, npoints
	
	if (ItemsInList(tList) < 2)
		DoAlert/T="Unsupported Math" 0, "Math operations are only supported from graphs with at least two traces"
		return -1
	endif
	
	wave/Z wX = XWaveRefFromTrace(fWin,StringFromList(0,tList))	
	if (WaveExists(wX))
		DoAlert/T="Unsupported Math" 0, "Math operations are only supported on scaled waves"
		return -1
	endif
	
	ntraces = ItemsInList(tList)
	wave ww = TraceNametoWaveRef(fWin,StringFromList(0,tList))
	npoints = DimSize(ww,0)
	for (ic=1;ic<ntraces;ic++)
		wave ww = TraceNametoWaveRef(fWin,StringFromList(ic,tList))
		if (DimSize(ww,0) != npoints)
			DoAlert/T="Unsupported Math", 0, "Math operations are only supported when all traces have the same number of points."
			return -1
		endif
	endfor
	
	return 0
end

// @brief attach the panel
Static Function attach_SpXZgRMathPanel()

	variable xpos=10
	variable ypos=10
	DoWindow/F SpXZgRMathGraph
	if (v_flag == 0)
		return -1
	endif

	NewPanel/W=(0,0,k_spxzgrmpwidth,k_spxzgrmpheight)/N=$k_SpXZgRMathPanel/HOST=SpXZgRMathGraph/EXT=2/K=2 as "SpXZeigR Math"
	ModifyPanel fixedSize=1, noEdit=1

	Slider scalefactor,pos={xpos,ypos},size={55,160},proc=csl_SpXZgRMath,help={"scale factor for reference"}
	Slider scalefactor,fSize=12,limits={0,10,0},value=1,ticks=10

	CheckBox checklog,pos={xpos+50,ypos+5},size={32,16},proc=ccb_SpXZgRMath,title="log",fSize=10,value=0,help={"set log scale on graph"}

	Button refresh,pos={xpos+100,ypos},size={60,20},proc=cbc_SpXZgRMath,title="Refresh",fSize=12,help={"refresh graph used for spectra"}

	SetVariable srcGraphTitle,pos={xpos+170,ypos},size={180,20},disable=2,fSize=12,value=_STR:"",help={"current graph being analyzed."}
	CheckBox srcGraphDiff, pos={xpos+170+190,ypos}, disable=2, fSize=10, value=0, title="!", help={"current analysis is not using the frontmost graph"}
	SetVariable srcGraphName,pos={xpos+180,ypos},size={20,14},disable=1,fSize=9,value=_STR:""

	ypos+=25
	xpos=65
	
	PopupMenu pSpectrum,pos={xpos,ypos},size={200,20},bodyWidth=190,proc=cpu_SpXZgRMath,title="S",fSize=14,fStyle=1
	PopupMenu pSpectrum,mode=1,value=#"SpXZgRMath#f_TraceList()",help={"set spectrum trace"}

	Button stepup,pos={xpos+252,ypos},size={20,20},proc=cbc_SpXZgRMath,title="\\[0↑",fSize=10,help={"increment traces"}

	Slider offset,pos={xpos+280,ypos+5},size={70,80},proc=csl_SpXZgRMath,fSize=12,limits={-1,1,0},value=0,ticks=10,help={"set offset relative fraction"}

	ypos+=22

	CheckBox checkabs,pos={xpos,ypos},size={32,16},proc=ccb_SpXZgRMath,title="|... |",fSize=10,value=0,help={"absolute value for result"}
	PopupMenu method,pos={xpos+32,ypos},size={110,20},proc=cpu_SpXZgRMath,title="",fSize=12,help={"choose method"}
	PopupMenu method,mode=1,value=#"SpXZgRMath#f_MathOps()"

	Button swap,pos={xpos+252,ypos-4},size={20,30},proc=cbc_SpXZgRMath,title="\\[0↑\r\\X0\r↓",fSize=10,help={"swap traces"},disable=2

	ypos+=23

	PopupMenu pReference,pos={xpos,ypos},size={200,20},bodyWidth=190,proc=cpu_SpXZgRMath,title="R",fSize=14,fStyle=1
	PopupMenu pReference,mode=1,value=#"SpXZgRMath#f_TraceList(wbase=1)",help={"set reference trace"}

	Button stepdown,pos={xpos+252,ypos},size={20,20},proc=cbc_SpXZgRMath,title="\\[0↓",fSize=10,help={"decrement traces"}

	ypos+=23

	ValDisplay sfval,pos={xpos+10,ypos},size={60,20},disable=2,title="x",fSize=12,format="%3.3f",value=_NUM:1

	SetVariable exponent,pos={xpos+75,ypos},size={75,18},proc=csv_SpXZgRMath,help={"set exponent for scale factor"}
	SetVariable exponent,title="x10^",fSize=12,format="%2.0f",value=_NUM:0

	Button resetsf,pos={xpos+160,ypos-1},size={60,20},proc=cbc_SpXZgRMath,title="reset ×",fSize=12,help={"reset scale factor"}

	ypos+=23
	
	Button resetall,pos={xpos+125,ypos},size={60,20},proc=cbc_SpXZgRMath,title="RESET",fSize=12,help={"reset all inputs on panel"}
	Button resetoffset,pos={xpos+205,ypos},size={60,20},proc=cbc_SpXZgRMath,title="reset ⊻",fSize=12,help={"reset offset"}
	ValDisplay ofval,pos={xpos+270,ypos},size={50,17},disable=2,fSize=12,format="%3.3f",value=_NUM:0
	
	ypos+=28
	
	Button save,pos={xpos,ypos},size={50,20},proc=cbc_SpXZgRMath,title="SAVE",fSize=12,help={"save results"}
	Button auto,pos={xpos+100,ypos},size={50,20},proc=cbc_SpXZgRMath,title="Auto",fSize=12,disable=2,help={"auto set the scale factor"}	
	SetVariable autopnts,pos={xpos+160,ypos},size={90,18},proc=csv_SpXZgRMath,title="<-(c)->",fSize=12,format="%2.0f"
	SetVariable autopnts,limits={3,inf,1},value=_NUM:3,disable=2,help={"set points for autooptimize span"}
	CheckBox checkzero,pos={xpos+270,ypos-3},size={85,16},proc=ccb_SpXZgRMath,title="(c)=0",fSize=12
	CheckBox checkzero, value=0,help={"use a cursor to set the location for the baseline zero"}, disable=2

	return 0
end

// @brief show the math panel
// how = 0 bring forward; how = 1 create
Static Function show_SpXZgRMathGraph(variable how)

	wave/Z/SDFR=$k_SpXZgRPackageFolder mathOPR
	
	switch(how)
		case 0:	// just display
			display/N=SpXZgRMathGraph/K=1
			break
		case 1:	// append data
			if (waveexists(mathOPR)==0)
				KillWindow/Z SpXZgRMathGraph
				KillWindow/Z SpXZgRMathPanel				
			else
				appendtograph/W=SpXZgRMathGraph mathOPR
				ControlInfo/W=$k_SpXZgRMathPanel srcGraphName
				GetAxis/W=$s_value/Q bottom
				if (v_min > v_max)
					SetAxis/W=SpXZgRMathGraph bottom, v_min, v_max
				else
					SetAxis/W=SpXZgRMathGraph bottom, v_max, v_min			
				endif
				SetAxis/A=2/W=SpXZgRMathGraph left
				ModifyGraph/W=SpXZgRMathGraph rgb=(0,0,0), grid(left)=2, lsize=2
				GetWindow $s_value wsize
				MoveWindow/W=SpXZgRMathGraph v_right+10-k_spxzgrmpwidth, v_top+10, -1, -1
			endif
			break
		default:
			break
	endswitch
	return 0
end

// @brief reset values on panel
Static Function reset_SpXZgRMathPanel(variable how)

	string fWin, cWin
	variable updateme = 1
	
	switch(how)
		case 0:		// reset all
			fWin = StringFromList(0,WinList("!SpXZgRMathGraph",";","WIN:1"))
			ControlInfo/W=$k_SpXZgRMathPanel srcGraphName
			if (cmpstr(s_value,fWin) == 0)
				updateme = 0
				break
			endif
			SetVariable srcGraphName, win=$k_SpXZgRMathPanel, value=_STR:fWin
			GetWindow $fWin wtitle
			SetVariable srcGraphTitle, win=$k_SpXZgRMathPanel, value=_STR:s_value
			PopupMenu pSpectrum, win=$k_SpXZgRMathPanel, value=SpXZgRMath#f_TraceList(), mode=1
			PopupMenu pReference, win=$k_SpXZgRMathPanel, value=SpXZgRMath#f_TraceList(wbase=1), mode=1
			DoWindow/F SpXZgRMathGraph
			break
		case 1:		// reset all scalings
			Slider scalefactor, win=$k_SpXZgRMathPanel, value=1
			SetVariable exponent, win=$k_SpXZgRMathPanel, value=_NUM:0
			Slider offset, win=$k_SpXZgRMathPanel, value=0
			break
		case 2:		// reset only scale factor
			Slider scalefactor, win=$k_SpXZgRMathPanel, value=1
			SetVariable exponent, win=$k_SpXZgRMathPanel, value=_NUM:0
			break
		case 3:		// reset only offset
			Slider offset, win=$k_SpXZgRMathPanel, value=0
			break
		case -1:		// validations
			// reference is zero?
			ControlInfo/W=$k_SpXZgRMathPanel pReference
			if (v_value == 1)
				Slider scalefactor, win=$k_SpXZgRMathPanel, disable=2
				SetVariable exponent, win=$k_SpXZgRMathPanel, disable=2
				Slider offset, win=$k_SpXZgRMathPanel, disable=2		
				Checkbox checkzero, win=$k_SpXZgRMathPanel, disable=2, value=0		
			else
				Slider scalefactor, win=$k_SpXZgRMathPanel, disable=0
				SetVariable exponent, win=$k_SpXZgRMathPanel, disable=0
				Slider offset, win=$k_SpXZgRMathPanel, disable=0
				Checkbox checkzero, win=$k_SpXZgRMathPanel, disable=0
			endif
			// zero at cursor?
			ControlInfo/W=$k_SpXZgRMathPanel checkzero
			set_SpXZgRMathCrsr(v_value)
			if (v_value == 1)
				Button auto, win=$k_SpXZgRMathPanel, disable=0
				SetVariable autopnts, win=$k_SpXZgRMathPanel, disable=0
				Slider offset, win=$k_SpXZgRMathPanel, disable=2, value=0
				Button resetoffset, win=$k_SpXZgRMathPanel, disable=2
			else
				Button auto, win=$k_SpXZgRMathPanel, disable=2
				SetVariable autopnts, win=$k_SpXZgRMathPanel, disable=2, value=_NUM:3
				Slider offset, win=$k_SpXZgRMathPanel, disable=0
				Button resetoffset, win=$k_SpXZgRMathPanel, disable=0
			endif
			break
		default:
			break
	endswitch
	ControlUpdate/W=$k_SpXZgRMathPanel/A
	if (updateme)
		SpXZgR_updatemathfrompanel()
	else
		DoWindow/F $fWin
	endif
	
	return 0
end

// @brief update math from panel
Static Function SpXZgR_updatemathfrompanel()

	STRUCT SpXZgR_MathStruct math
	fill_SpXZgRMathStruct(math)
	SpXZgR_domath(math)
	ValDisplay sfval, win=$k_SpXZgRMathPanel, value=_NUM:math.sf
	ValDisplay ofval, win=$k_SpXZgRMathPanel, value=_NUM:math.offset
	return 0
end

// @brief do the math operation
Static Function SpXZgR_domath(STRUCT SpXZgR_MathStruct &math)

	string fWin, theTrace
	fWin = math.srcgraphName
	theTrace = math.src
	wave wS = TraceNameToWaveRef(fWin,theTrace)
	theTrace = math.ref
	if (cmpstr(theTrace,"zero")==0)
		duplicate/FREE wS, wR
		wR = 0
	else
		wave wR = TraceNameToWaveRef(fWin,theTrace)
	endif
	
	wave mathOPF = SpXZgR_domathOP(wS, wR, math)

	DFREF pdf = $k_SpXZgRPackageFolder
	DFREF cdf = GetDataFolderDFR()
	SetDataFolder pdf
	duplicate/O mathOPF mathOPR
	SetDataFolder cdf
	
	killwaves/Z mathOPF
	return 0
end

// *** WORK HERE

// @brief increment or decrement trace value(s)
Static Function SpXZgR_stepmathtrace(variable direction)

	variable pSn, pRn, vNs
	
	vNs = ItemsInList(f_TraceList())
	switch(direction)
		case -2:	// both down
			ControlInfo/W=$k_SpXZgRMathPanel pSpectrum
			pSn = v_value
			ControlInfo/W=$k_SpXZgRMathPanel pReference
			pRn = v_value
			// decrement both
			if ((pRn != 1) && (pSn != 1))
				print "both down"
			endif
			break
		case -1:	// reference down
			break
		case 1:	// spectrum up
			break
		case 2:	// both up
			ControlInfo/W=$k_SpXZgRMathPanel pSpectrum
			pSn = v_value
			ControlInfo/W=$k_SpXZgRMathPanel pReference
			pRn = v_value
			// increment both
			if ((pRn < vNs) && (pSn < vNs))
				print "both up"
			endif
			break
		default:
			break
	endswitch	
	
	return 0
end

// @brief return math operations
Static Function/S f_MathOps()

	string rstr
	rstr = "S+sf*R+b;S-sf*R+b;S*sf*R+b;S/(sf*R+b);(S-sf*R+b)/(sf*R+b);(S-sf*R+b)/(S+sf*R+b);S/(S-sf*R+b);"
	return rstr
end

// @brief return wave representing math operation
Static Function/WAVE SpXZgR_domathOP(wave wS, wave wR, STRUCT SpXZgR_MathStruct &math)	
	
	variable reloff
	duplicate/FREE wS rW
	reloff = math.offset*(wavemax(wR) - wavemin(wR))
	switch(math.method)
		case 0:	// reset
			break
		case 1:	// add
			rW = wS + ((math.sf*10^math.ex)*wR + reloff)
			break
		case 2:	// subtract
			rW = wS - ((math.sf*10^math.ex)*wR + reloff)
			break
		case 3:	// multiply
			rW = wS * ((math.sf*10^math.ex)*wR + reloff)
			break
		case 4:	// divide
			rW = wS / ((math.sf*10^math.ex)*wR + reloff)
			break
		case 5:	// relative
			rW = wS - ((math.sf*10^math.ex)*wR + reloff)
			rW /= ((math.sf*10^math.ex)*wR + reloff)
			break
		case 6:	// relative to sum
			rW = wS - ((math.sf*10^math.ex)*wR + reloff)
			rW /= wS + ((math.sf*10^math.ex)*wR + reloff)
			break
		case 7:	// inverted
			rW /= wS - ((math.sf*10^math.ex)*wR + reloff)
			rW *= wS
			break
		default:
			break
	endswitch
	if (math.zatc == 1)
		reloff = rW[math.patc]
		rW -= reloff
	endif
	if (math.sabs == 1)
		rW = abs(rW)
	endif
	return rW
end

Static Function SpXZgR_doautooptimize()

	string fWin, theTrace
	variable sf, vm, ve
	
	STRUCT SpXZgR_MathStruct math
	fill_SpXZgRMathStruct(math)	

	if (math.method > 2)
		return 0
	endif
	
	fWin = math.srcgraphName
	theTrace = math.src
	wave wS = TraceNameToWaveRef(fWin,theTrace)
	theTrace = math.ref
	wave wR = TraceNameToWaveRef(fWin,theTrace)

	sf = SpXZgR_autooptimize(wS, wR, math)
	switch(math.method)
		case 1:		// addition
			if (sf > 0)
				return 0
			endif
			sf = abs(sf)
			break
		case 2:		// subtraction
			if (sf < 0)
				return 0
			endif
			break
		default:
			break
	endswitch
	
	[vm, ve] = get_SpXZgRscinot(sf)
	math.sf = vm
	math.ex = ve
	SpXZgR_domath(math)
	ValDisplay sfval, win=$k_SpXZgRMathPanel, value=_NUM:math.sf
	Slider scalefactor, win=$k_SpXZgRMathPanel, value=vm
	SetVariable exponent, win=$k_SpXZgRMathPanel, value=_NUM:ve
	
	return 0
end

// returns scientific notation vm x 10^ve parameters for input vv
Static Function [variable vm, variable ve] get_SpXZgRscinot(variable vv)

	ve = floor(log(vv))
	vm = vv * 10^(-ve)
	return [vm, ve]
end

Static Function SpXZgR_autooptimize(wave wS, wave wR, STRUCT SpXZgR_MathStruct &math)
	
	variable ip, fp
	make/N=2/FREE/D wcoeff = {0,1}
	
	ip = math.patc - math.apnts
	if (ip < 0)
		ip = 0
	endif
	fp = math.patc + math.apnts
	if (fp > (numpnts(wR)-1))
		fp = numpnts(wR) - 1
	endif

	duplicate/FREE/R=[ip,fp] wS, fwS
	duplicate/FREE/R=[ip,fp] wR, fwR

	CurveFit/Q line kwCWave=wcoeff, fWs /X=fwR
	killwaves/Z w_sigma
	
	return wcoeff[1]
end

// @brief swap traces in math operation
Static Function swap_SpXZgRTraces()

	variable ps, pr
	ControlInfo/W=$k_SpXZgRMathPanel pSpectrum
	ps = v_value
	ControlInfo/W=$k_SpXZgRMathPanel pReference
	pr = v_value	
	PopupMenu pSpectrum, win=$k_SpXZgRMathPanel, mode=pr-1
	PopupMenu pReference, win=$k_SpXZgRMathPanel, mode=ps+1
	//ControlUpdate/W=$k_SpXZgRMathPanel/A
	SpXZgR_updatemathfrompanel()
	return 0
end

// @brief save math results
Static Function SpXZgR_savemathresults()

	wave/Z/SDFR=$k_SpXZgRPackageFolder mathOPR
	
	string mathS, newName, wnote, mathOP
	string mathSList = "add;sub;mul;div;rel;xel;irl;"
	variable wop
	
	if (waveexists(mathOPR)==0)
		return -1
	endif
	
	STRUCT SpXZgR_MathStruct math
	fill_SpXZgRMathStruct(math)	
	ControlInfo/W=$k_SpXZgRMathPanel method
	mathOP = s_value
	mathS = "(" + StringFromList(v_value-1,mathSList) + ")"
	newName = math.src + mathS + math.ref
	duplicate/O mathOPR $newName
	wave nwave=$newName
	wnote = "Math Operation " + date() + " " + time() +"\r"
	wnote += math.src + " (" + mathOP + ") " + math.ref +"\r"
	wnote += "scale factor: " + num2str(math.sf) + "x10^" + num2str(math.ex) + " offset: " + num2str(math.offset)
	Note nwave, wnote
	wnote = ""
	if (math.zatc == 1)
		wnote = "zero at cursor " + num2str(math.patc) + " over points " + num2str(math.apnts) + "\r"
	endif
	if (math.sabs == 1)
		wnote = "absolute value\r"
	endif
	if (strlen(wnote) != 0)
		Note nwave, wnote
	endif
	return 0
end

Function csl_SpXZgRMath(STRUCT WMSliderAction &sa) : SliderControl

	switch(sa.eventCode)
		case -3:		// fallthrough Control received keyboard focus
		case -2:		// fallthrough Control lost keyboard focus
		case -1:		// fallthrough Control being killed
			break
		default:
			if (sa.eventCode & 1)
				SpXZgR_updatemathfrompanel()
			endif
//			if (sa.eventCode & 8)	// Mouse moved or arrow key moved the slider
//				SpXZgR_updatemathfrompanel()
//			endif
			break
	endswitch

	switch( sa.eventCode )
		case 2:
			SpXZgR_updatemathfrompanel()
			break
		default:
			break
	endswitch
//	reset_SpXZgRMathPanel(-1)
	return 0
End

Function csv_SpXZgRMath(STRUCT WMSetVariableAction &sva) : SetVariableControl

	switch( sva.eventCode )
		case 1: // fallthrough mouse up
		case 2: // fallthrough Enter key
		case 3: // fallthrough Live update
			strswitch(sva.ctrlName)
				case "autopnts":
					SpXZgR_doautooptimize()
					break
				default:
					SpXZgR_updatemathfrompanel()
					break
			endswitch
			reset_SpXZgRMathPanel(-1)
			break
		default:
			break
	endswitch
	return 0
End

Function cpu_SpXZgRMath(STRUCT WMPopupAction &pa) : PopupMenuControl

	switch( pa.eventCode )
		case 2: // mouse up
			strswitch(pa.ctrlName)
				case "pReference":
					Button swap, win=$k_SpXZgRMathPanel, disable=(2*(pa.popNum == 1))
					break
				default:
					break
			endswitch
			SpXZgR_updatemathfrompanel()
			reset_SpXZgRMathPanel(-1)
			break
		default:
			break
	endswitch
	return 0
End

Function cbc_SpXZgRMath(STRUCT WMButtonAction &ba) : ButtonControl

	switch( ba.eventCode )
		case 2: // mouse up
			// click code here
			strswitch(ba.ctrlName)
				case "swap":
					swap_SpXZgRTraces()
					reset_SpXZgRMathPanel(-1)
					break
				case "refresh":
					reset_SpXZgRMathPanel(0)
					break
				case "resetall":
					reset_SpXZgRMathPanel(1)
					break
				case "resetsf":
					reset_SpXZgRMathPanel(2)
					break
				case "resetoffset":
					reset_SpXZgRMathPanel(3)
					break
				case "auto":
					SpXZgR_doautooptimize()
					reset_SpXZgRMathPanel(-1)
					break
				case "save":
					SpXZgR_savemathresults()
					break
				default:
					break
			endswitch
			break
		default:
			break
	endswitch
	return 0
End

Static Function set_SpXZgRMathCrsr(variable onoff)

	if (onoff)
		if (strlen(CsrInfo(A,"SpXZgRMathGraph"))==0)
			Cursor/H=3/N=1/P/W=SpXZgRMathGraph A, mathOPR, 10
			Slider offset, win=$k_SpXZgRMathPanel, value=0, disable=2
			SetWindow SpXZgRMathGraph, hook(SpXZgR)=hf_SpXZgRMath
		endif
	else
		SetWindow SpXZgRMathGraph, hook(SpXZgR)=$""
		Cursor/K/W=SpXZgRMathGraph A
		Slider offset, win=$k_SpXZgRMathPanel, disable=0
	endif
	return 0
end

// @brief hook function for math window
Function hf_SpXZgRMath(STRUCT WMWinHookStruct &ss)
	
	variable rhf = 0
	string fWin
	switch(ss.eventCode)
		case 0:	// activate
			fWin = WinName(0,1)
			ControlInfo/W=$k_SpXZgRMathPanel srcGraphTitle
			rhf = cmpstr(fWin,s_value)
			CheckBox srcGraphDiff, win=$k_SpXZgRMathPanel, value=rhf
			break
		case 7:
			update_fromSpXZgRmathCrsr()
			rhf=1
			break
		case 2:
			SetWindow SpXZgRMathGraph, hook(SpXZgR)=$""
			break
		default:
			break
	endswitch
	return rhf
end

// @brief run this when math window cursor moves
Static Function update_fromSpXZgRmathCrsr()

	STRUCT SpXZgR_MathStruct math
	fill_SpXZgRMathStruct(math)
	math.zatc = 1
	math.patc = pcsr(A,"SpXZgRMathGraph")
	SpXZgR_domath(math)
	return 0
end

// @brief set variations on math graph
Static Function set_SpXZgRMathGraph()

	ControlInfo/W=$k_SpXZgRMathPanel checklog
	if (v_value)
		ModifyGraph/W=SpXZgRMathGraph log(left)=1
	else
		ModifyGraph/W=SpXZgRMathGraph log(left)=0	
	endif
	
	return 0
end

// @brief checkbox procedure
Function ccb_SpXZgRMath(STRUCT WMCheckboxAction &cba) : CheckBoxControl

	switch(cba.eventCode)
		case 2: // mouse up
			strswitch(cba.ctrlName)
				case "checkzero":
					set_SpXZgRMathCrsr(cba.checked)
					reset_SpXZgRMathPanel(-1)
					break
				case "checkabs":
					break
				case "checklog":
					set_SpXZgRMathGraph()
					break
				default:
					break
			endswitch
			SpXZgR_updatemathfrompanel()
			reset_SpXZgRMathPanel(-1)
			break
		default:
			break
	endswitch
	return 0
End
